val path = "/opt/spark-data/payments"

val df = spark.read.option("delimiter", ",").option("inferSchema", "true").option("header", "true").csv(path)

val df2 = df.select("payment_id","amount").filter("amount > 2")








//Pure SQL interface

df.createOrReplaceTempView("payment")
val df3 = spark.sql("select payment_id,amount from payment where amount>2")




//Working with partitions 

val path = "/opt/spark-data/payments-partitions"

val dfp = spark.read.option("delimiter", ",").option("inferSchema", "true").option("header", "true").csv(path)

dfp.createOrReplaceTempView("paymentpart")
val df3 = spark.sql("select payment_id,amount from paymentpart where amount>2 and country='italy'")



//Working with parquet

//sqlContext.setConf("spark.sql.parquet.compression.codec","snappy");
df.write.parquet("/opt/spark-data/payments-result-parquet"); 